/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.dialog.comp.DecimalPlacePanel;
import DE.siemens.ad.logo.dialog.comp.IntegerOrReferencePanel;
import DE.siemens.ad.logo.dialog.comp.MeasurementPanel;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogTriggerParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;

public class AnalogTriggerPanel
extends AbstractProtectionPanel {
    private BorderJPanel ivjBorderJpanel = null;
    private DecimalPlacePanel fDecimalPlacesPanel;
    private JPanel ivjParameterPanel = null;
    private MeasurementPanel ivjMeasurementRange = null;
    private IntegerOrReferencePanel ivjHighTrigger = null;
    private IntegerOrReferencePanel ivjLowTrigger = null;

    public AnalogTriggerPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.addParameterPane(this.getParameterPanel((AnalogTriggerParameter)parameterReference));
    }

    public boolean checkChanged() {
        if (this.getHighTrigger().checkChanged()) {
            return true;
        }
        if (this.getLowTrigger().checkChanged()) {
            return true;
        }
        if (this.getMeasurementRange().checkChanged()) {
            return true;
        }
        if (this.fDecimalPlacesPanel.checkChanged()) {
            return true;
        }
        return super.checkChanged();
    }

    public boolean checkFieldContents() {
        if (!this.getHighTrigger().checkValue(true)) {
            return false;
        }
        if (!this.getLowTrigger().checkValue(true)) {
            return false;
        }
        if (!this.getMeasurementRange().checkValue(true)) {
            return false;
        }
        if (!this.fDecimalPlacesPanel.checkFieldContents()) {
            return false;
        }
        return super.checkFieldContents();
    }

    private BorderJPanel getBorderJpanel() {
        if (this.ivjBorderJpanel == null) {
            try {
                this.ivjBorderJpanel = new BorderJPanel();
                this.ivjBorderJpanel.setName("BorderJpanel");
                this.ivjBorderJpanel.setTitle("Trigger");
                this.ivjBorderJpanel.setLayout(new GridBagLayout());
                GridBagConstraints gbc = null;
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 1;
                this.getBorderJpanel().add((Component)this.getHighTrigger(), gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.fill = 1;
                this.getBorderJpanel().add((Component)this.getLowTrigger(), gbc);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBorderJpanel;
    }

    private IntegerOrReferencePanel getHighTrigger() {
        if (this.ivjHighTrigger == null) {
            try {
                this.ivjHighTrigger = new IntegerOrReferencePanel();
                this.ivjHighTrigger.setName("HighTrigger");
                this.ivjHighTrigger.setBounds(121, 16, 70, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjHighTrigger;
    }

    private IntegerOrReferencePanel getLowTrigger() {
        if (this.ivjLowTrigger == null) {
            try {
                this.ivjLowTrigger = new IntegerOrReferencePanel();
                this.ivjLowTrigger.setName("LowTrigger");
                this.ivjLowTrigger.setBounds(121, 43, 70, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLowTrigger;
    }

    private MeasurementPanel getMeasurementRange() {
        if (this.ivjMeasurementRange == null) {
            try {
                this.ivjMeasurementRange = new MeasurementPanel();
                this.ivjMeasurementRange.setName("MeasurementRange");
                this.ivjMeasurementRange.setLocation(1, 1);
                this.ivjMeasurementRange.setModel(((AnalogTriggerParameter)this.fParameterReference).getMeasurement());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMeasurementRange;
    }

    private JPanel getParameterPanel(AnalogTriggerParameter parameterReference) {
        if (this.ivjParameterPanel == null) {
            try {
                this.ivjParameterPanel = new JPanel();
                this.ivjParameterPanel.setName("ParameterPanel");
                this.ivjParameterPanel.setLayout(new GridBagLayout());
                GridBagConstraints gbc = null;
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.weighty = 1.0;
                gbc.gridwidth = 2;
                gbc.fill = 1;
                this.ivjParameterPanel.add((Component)this.getMeasurementRange(), gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 2;
                this.ivjParameterPanel.add((Component)this.getBorderJpanel(), gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.weightx = 1.0;
                this.ivjParameterPanel.add((Component)new JPanel(), gbc);
                this.fDecimalPlacesPanel = new DecimalPlacePanel();
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.anchor = 16;
                gbc.weighty = 1.0;
                gbc.gridwidth = 2;
                gbc.insets = new Insets(3, 5, 0, 5);
                this.ivjParameterPanel.add((Component)this.fDecimalPlacesPanel, gbc);
                if (!parameterReference.getBlock().getHardware().supports("AnalogTrigger_ref")) {
                    this.ivjHighTrigger.setReferenceVisability(false);
                    this.ivjLowTrigger.setReferenceVisability(false);
                }
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjParameterPanel;
    }

    private void handleException(Throwable exception) {
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        try {
            this.getMeasurementRange().loadFieldContents();
        }
        catch (ProgramException e) {
            e.printStackTrace();
        }
        AnalogTriggerParameter analogTriggerParameter = (AnalogTriggerParameter)this.fParameterReference;
        WiringDiagram wiringDiagram = ((BlockParameter)this.fParameterReference).getBlock().getWiringDiagram();
        Block notIncluded = ((BlockParameter)this.fParameterReference).getBlock();
        ArrayList blocksForReference = wiringDiagram.getBlocksForReference(notIncluded, true);
        this.getHighTrigger().setReferenceList(blocksForReference);
        this.getLowTrigger().setReferenceList(blocksForReference);
        this.getHighTrigger().setProperties(analogTriggerParameter.getOn());
        this.getLowTrigger().setProperties(analogTriggerParameter.getOff());
        this.fDecimalPlacesPanel.setAnalog((Analog)this.fParameterReference);
        this.fDecimalPlacesPanel.loadFieldContents();
    }

    public void setLabels() {
        super.setLabels();
        this.getMeasurementRange().setLabels();
        this.getBorderJpanel().setTitle(Language.getString("dialog.parameter.analogTrigger.triggerBorder", "Treshold"));
        this.getHighTrigger().setTitle(Language.getString("dialog.parameter.analog.on", "On"));
        this.getLowTrigger().setTitle(Language.getString("dialog.parameter.analog.off", "Off"));
        this.fDecimalPlacesPanel.setLabels();
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        AnalogTriggerParameter analogTriggerParameter = (AnalogTriggerParameter)this.fParameterReference;
        this.getMeasurementRange().storeFieldContents();
        analogTriggerParameter.setOnTriggerProperties(this.getHighTrigger().getValue());
        analogTriggerParameter.setOffTriggerProperties(this.getLowTrigger().getValue());
        this.fDecimalPlacesPanel.setAnalog((Analog)this.fParameterReference);
        this.fDecimalPlacesPanel.storeFieldContents();
    }
}

